﻿/* RK: File Created: March 25, 2013 */

function SetControlsState(enabled) {
    if (!document.all['FindCode'])
        return;
    document.all['FindCode'].disabled = !enabled;
    document.all['codequery'].disabled = !enabled;
    document.all['FindLabel'].disabled = !enabled;
    document.all['labelquery'].disabled = !enabled;

    for (var i = 0; i < document.links.length; i++) {
        var elem = document.links[i];

        if (enabled)
            elem.style.display = 'inline';
        else
            elem.style.display = 'none';
    }

}

function PageKeyUp() {
    if (window.parent && window.parent.document && window.parent.ProcessKey) {
        window.parent.ProcessKey(window.event.keyCode);
    }

}

function QueryBoxKeyDown(buttonid, sender) {
    if (window.event.keyCode == 13) {
        var btn = document.getElementById(buttonid);
        if (btn) {
            btn.focus();
            btn.click();
        }
    }
}

function CanAddSelection() {
    return (parseInt(document.getElementById('maxSelection').value) <= 1) || parseInt(document.getElementById('selectionCount').value) < parseInt(document.getElementById('maxSelection').value);
}

function IncrementSelectionCount() {
    document.getElementById('selectionCount').value = parseInt(document.getElementById('selectionCount').value) + 1;
}

function DecrementSelectionCount() {
    document.getElementById('selectionCount').value = parseInt(document.getElementById('selectionCount').value) - 1;
}

function SelectionButtonClick(sender, question, code, label, customdata) {

    if (sender.checked) {
        if (!CanAddSelection()) {
            sender.checked = false;
            return;
        }
        if (sender.type == 'radio') {
            var inputs = document.getElementsByTagName('input');

            for (var i = 0; i < inputs.length; i++) {
                if (inputs[i] != sender && inputs[i].type == 'radio') {
                    inputs[i].checked = false;
                }
            }
        }
        AddSelection(question, code, label, customdata);
    }
    else {
        RemoveSelection(question, code, label, customdata);
    }
}

function AddSelection(question, code, label, customdata) {
    if (window.parent && window.parent.document) {
        IncrementSelectionCount();

        var maxAnswer = window.parent.document.forms[0][question + ':MAXANSWER'].value;
        var textbox;
        var customvalue;
        var datalabel;

        if (maxAnswer <= 1) {
            for (var i = 0; i < window.parent.document.forms[0].length; i++) {
                var elem = window.parent.document.forms[0][i];
                if (elem.type == 'radio')
                    elem.checked = false;
            }
        }

        for (i = 1; i <= maxAnswer; i++) {
            textbox = window.parent.document.forms[0][question + ':ANSWER:' + i];
            if (textbox.value.toUpperCase() == code.toUpperCase())
                return;
        }

        for (i = 1; i <= maxAnswer; i++) {
            textbox = window.parent.document.forms[0][question + ':ANSWER:' + i];
            customvalue = window.parent.document.forms[0][question + ':CUSTOMDATA:' + i];
            datalabel = window.parent.document.forms[0][question + ':DATALABEL:' + i];


            if (textbox.value == '') {
                break;
            }
        }


        if (textbox)
            textbox.value = code;
        if (customvalue)
            customvalue.value = customdata;
        if (datalabel)
            datalabel.value = label;
    }
}


function RemoveSelection(question, code, label, customdata) {
    if (window.parent && window.parent.document) {
        DecrementSelectionCount();
        var maxAnswer = window.parent.document.forms[0][question + ':MAXANSWER'].value;
        var textbox;
        var customvalue;
        var datalabel;

        for (i = 1; i <= maxAnswer; i++) {
            textbox = window.parent.document.forms[0][question + ':ANSWER:' + i];

            if (textbox.value.toUpperCase() == code.toUpperCase()) {
                customvalue = window.parent.document.forms[0][question + ':CUSTOMDATA:' + i];
                datalabel = window.parent.document.forms[0][question + ':DATALABEL:' + i];

                if (customvalue)
                    customvalue.value = '';
                if (datalabel)
                    datalabel.value = '';

                textbox.value = '';
                return;
            }
        }
    }
}